*******************************************************************************
*                     68000/68010 Grundprogramm screen                        *
*                        (C) 1990 Ralph Dombrowski                            *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                            Bildschirmroutinen                               *
*******************************************************************************


cursorein:
 tst.b  curon(a5)
 beq.s  curf                    * Ende, wenn Cursor aus
 movem.l d0-d2/a0-a2,-(a7)
 bsr    calccur
 lea    erapen(pc),a0
 lea    setpen(pc),a1
bra.s   cursorneu

cursoraus:
 tst.b  curon(a5)
 beq.s  curf                    * Ende, wenn Cursor aus
 movem.l d0-d2/a0-a2,-(a7)
 bsr    calccur
 lea    setpen(pc),a0
 lea    erapen(pc),a1

cursorneu:
 clr.b  wrtpage(a5)
 bsr    aktpage                 * Cursor auf Seite 0 (ohne autoflip sichtbar)
 bsr    aktcur
 tst.b  cotempo(a5)             * Hardscroll an ?
 bne.s  cursorn0                * Ja, dann weiter
 cmp    #11,d2                  * Zu tief ?
 bpl.s  cursorn1                * Nein, dann weiter
bra.s   nocursor
cursorn0:
 cmp    #249,d2
 bmi.s  cursorn1                * Zweimal ausgeben, wenn auf Bildschirmrand
 bsr.s  cursorn2
 sub    #256,d2
 bsr    moveto
cursorn1:
 bsr.s  cursorn2
nocursor:
 movem.l (a7)+,d0-d2/a0-a2
bra     setpen
curf:
rts

cursorn2:
 jsr    (a1)
 move.b #10,gdp.w               * Befehl Block setzen
 bsr    moveto
 jsr    (a0)
 move.b (a2),d0
bra cmdput                      * Und Ausgabe mit Sonderzeichen

aktcur:                         * Achtung d1/d2 werden nicht gerettet
 move.l d0,-(a7)                * Nur d0 retten
 moveq #0,d1
 move.b groesse(a5),d1          * Gre nach d1.l
 cmp.b #$11,d1                  * Gre $11 hat extra Routine
 beq.s akt1cur
 moveq #0,d0
 move.b curx(a5),d0             * X-Position nach d0.l
 add d0,d0
 move d0,d2
 add d0,d0
 add d2,d0                      * Curx * 6
 move d1,d2
 lsr #4,d1                      * SizeX
 mulu d0,d1                     * Position X = curx * sizex * 6
 and #$f,d2                     * SizeY
 neg d2
 move d2,d0
 add d2,d2
 add d2,d2
 add d0,d2
 add d2,d2                      * SizeY * -10
 moveq #1,d0
 add.b cury(a5),d0
 muls d0,d2
 add #256,d2                    * Position Y = 256 - 10 * sizey * (1+cury)
 add.b coscroll(a5),d2          * H-Scroll bercksichtigen
 bsr moveto                     * Positionieren
 move.b groesse(a5),gdp+3*cpu.w * Gre auch gleich einstellen
 move.l (a7)+,d0                * d0 zurck
rts

akt1cur:                        * Schnelle Routine fr Gre $11
 moveq #0,d1
 move.b curx(a5),d1
 move d1,d0
 add d1,d1
 add d0,d1
 add d1,d1                      * Position X = curx * 6
 move.b cury(a5),d0
 move d0,d2
 add d0,d0
 add d0,d0
 add d2,d0
 add d0,d0
 move #256-10,d2                * Position Y = 256-10-cury*10
 sub d0,d2
 add.b coscroll(a5),d2          * H-Scroll bercksichtigen
 bsr moveto
 move.b groesse(a5),gdp+3*cpu.w * Auch hier Gre einstellen
 move.l (a7)+,d0
rts

calccur:                        * cury ist Zeile
 move.b cury(a5),d0
getline:                        * d0 ist Zeile
 lea lineptr(a5),a0             * Zeiger auf Zeilenadresse
 lea linecnt(a5),a1             * Zeiger auf Anzahl Zeichen in Zeile
 and #$ff,d0
 move.b 0(a0,d0.w),d0           * Wirkliche Zeilennummer im Speicher
 adda d0,a1                     * a1 zeigt auf Zeichenzhler der Zeile
 lsl #4,d0
 move d0,-(a7)
 add d0,d0
 add d0,d0
 add (a7)+,d0                   * d0 * 80
 lea screen(a5),a0              * Adresse Bildschirmspeicher
 adda d0,a0                     * a0 = Adresse Zeilenanfang
 movea.l a0,a2
 moveq #0,d0
 move.b curx(a5),d0             * X-Position Cursor
 adda.l d0,a2                   * Adresse des Zeichens auf Cursorposition
rts

clrscreen:
 move.l d0,-(a7)                * Bildschirm lschen und Bildschirmspeicher auch
 clr.b xormode(a5)              * Kein XOR-Mode erlaubt
 move.b #1,curon(a5)            * Cursor anschalten
 bsr clrall                     * Alle Bildschirmseiten lschen
 move.b groesse(a5),gdp+3*cpu.w * Gre einstellen
 clr.b curx(a5)                 * Cursor steht links oben
 clr.b cury(a5)
 clr.b flip1(a5)                * Keine Vier-Seiten-Umschaltung
 move.b #10,flip(a5)            * Zwei-Seiten-Umschaltung anschalten
 move.b #10,flipcnt(a5)
 move.l (a7)+,d0
clrscr:                         * Einsprung Bildschirmspeicher lschen
 movem.l d0/d1/a0/a1,-(a7)
 lea screen(a5),a0              * Bildschirmbereich
 moveq #' ',d1                  * Space
 move #80*24-1,d0               * 24 Zeilen mit je 80 Zeichen
clrlp:
 move.b d1,(a0)+                * Bildschirmspeicher mit Leerzeichen fllen
dbra d0,clrlp
 lea lineptr+24(a5),a0
 lea linecnt(a5),a1
 moveq #24-1,d0
clrlp1:
 move.b d0,-(a0)                * Zeilen durchnummerieren
 clr.b (a1)+                    * Anzahl der Zeichen in jeder Zeile ist Null
dbra d0,clrlp1
 movem.l (a7)+,d0/d1/a0/a1
rts

homepos:                        * Bildschirmkoordinate links oben
 clr d1                         * X-Pos ist Null
 move.b groesse(a5),d2          * Gre holen
 and #$f,d2                     * Nur Hhe lassen
 muls #-10,d2                   * Mal 10 fr Hhe
 add #256,d2                    * Ecke links oben berechnet
rts

prt79hs:                        * prt79 aber Hardscroll fhig
 tst.b cotempo(a5)
 beq.s prt79                    * Normal, wenn ohne Hardscroll
 cmp #249,d2
 bmi.s prt791                   * OK, da nicht auf Seitenrand
 bsr.s prt791                   * Jetzt zweimal ausgeben
 sub #256,d2
 bsr moveto
 add #256,d2
bra.s prt791

prt79:                          * Zeile ausgeben; maximal 79 Zeichen
 cmp #11,d2                     * Zu tief ?
 bmi.s prtlfi                   * Ja, dann Ende
prt791:
 movem.l d0/d1/a0-a2,-(a7)
 bsr calccur                    * Zeileninfo holen
 move.b (a1),d1                 * Anzahl Zeichen holen
 cmp.b #80,d1                   * Wenn kleiner als 80,
 bmi.s prtx                     * dann ausgeben
 subq.b #1,d1                   * Sonst auf 79 setzen
bra.s prtx                      * Dann ausgeben

prtlinehs:                      * prtline aber Hardscroll fhig
 tst.b cotempo(a5)
 beq.s prtline                  * Normal, wenn ohne Hardscroll
 cmp #249,d2
 bmi.s prtline1                 * OK, da nicht auf Seitenrand
 bsr.s prtline1                 * Jetzt zweimal ausgeben
 sub #256,d2
 bsr moveto
 add #256,d2
bra.s prtline1

prtline:                        * Eine Zeile ausgeben
 cmp #11,d2                     * Zu tief ?
 bmi.s prtlfi                   * Ja, dann keine Ausgabe
prtline1:
 movem.l d0/d1/a0-a2,-(a7)
 bsr calccur                    * Zeileninfo holen
 move.b (a1),d1                 * Anzahl Zeichen nach d1
prtx:
 sub.b curx(a5),d1              * Aktuelle Position subtrahieren
 bls.s prtx1                    * Ende, da keine Zeichen hinter Cursor vorhanden
prtllp:
 cmp.b #1,gdp+8*cpu.w           * Schreibstift auerhalb des Screens ?
 bhi.s prtx1                    * Ja, dann Ende
 move.b (a2)+,d0                * Zeichen holen
 bsr cmdput                     * Ausgabe mit Sonderzeichen
 subq.b #1,d1                   * Erniedrigen bis
bne.s prtllp                    * alle Zeichen ausgegeben sind
prtx1:
 movem.l (a7)+,d0/d1/a0-a2
prtlfi:
rts

prtdy:                          * Zeilenabstand berechnen
 move.b groesse(a5),d5          * Schriftgre holen
 and #$f,d5
 muls #10,d5                    * Zeilenabstand berechnet
rts

prtr23:                         * Bis Zeile 23 ausgeben
 movem.l d0-d5/a0-a2,-(a7)
 moveq #23,d1                   * End-Zeile
bra.s prt2

prtrest:                        * Von aktueller Position bis Ende der Seite
 movem.l d0-d5/a0-a2,-(a7)      * ausgeben
 moveq #24,d1                   * End-Zeile
prt2:
 bsr calccur                    * Zeileninfo holen
 movea.l a2,a0                  * Adresse des Zeichens an Cursorposition nach a0
 move.b cury(a5),d2             * Anfangszeile
 move.b curx(a5),d4             * Anfangsspalte
 bsr.s prtdy                    * Zeilenabstand holen
bra.s prt1x

prttop:                         * Zeile 1 bis 24 ausgeben
 movem.l d0-d5/a0-a2,-(a7)
 moveq #24,d1                   * End-Zeile
 moveq #1,d2                    * Anfangszeile
 bsr.s prtdy                    * Zeilenabstand
bra.s prtlp1

prtall:                         * Ganzen Bildschirm ausgeben
 movem.l d0-d5/a0-a2,-(a7)
 bsr.s prtdy                    * Zeilenabstand berechnen
 moveq #24,d1                   * End-Zeile
 clr d2                         * Anfangszeile
prtlp1:
 move d2,d0
 bsr getline                    * Zeileninfo holen
 clr d4                         * Anfangsspalte
prt1x:
 move.b (a1),d3                 * Anzahl Zeichen holen
 beq.s prtskp                   * Null, dann nchste Zeile
prtlp2:
 cmp.b #1,gdp+8*cpu.w           * Schreibstift auerhalb des Screen ?
 bhi.s prtskp                   * Ja, dann nchste Zeile
 move.b (a0)+,d0                * Zeichen holen
 bsr cmdput                     * Ausgabe mit Sonderzeichen
 addq.b #1,d4                   * Erhhen
 cmp.b d3,d4                    * Bis Ende der Zeile
 bne.s prtlp2                   * erreicht
prtskp:
 addq.b #1,d2                   * Nchste Zeile
 cmp.b d1,d2                    * Bis Ende
 beq.s prtallfi                 * erreicht
prtskp1:
 btst.b #2,gdp.w                * Warten bis GDP fertig
 beq.s prtskp1
 move.b #$d,gdp.w               * Auf Anfang der Zeile
 move.b gdp+$a*cpu.w,d0
 lsl #8,d0
 move.b gdp+$b*cpu.w,d0         * Y-Position holen
 asl #4,d0
 asr #4,d0
 sub d5,d0                      * Neue Y-Position
 move.b d0,gdp+$b*cpu.w         * Nur LSB neu setzen, da Rest nicht verndert
 cmp #11,d0                     * Schreibstift zu tief ?
 bpl.s prtlp1                   * Nein, dann nchste Zeile
prtallfi:
 movem.l (a7)+,d0-d5/a0-a2
rts

putchar:                        * Sonderzeichenausgabe
 btst.b #6, keydil(a5)          * GDP-FPGA?
 beq.s putchar0                 * nein
 cmp.b #$a0, d0                 * Druckbares Zeichen?
 blt.s putchar0                 * nein, dann Sonderbehandlung
 and.b #$7f, d0                 * Bit 7 = 0
putchar3:                       * Wert an GDP schicken, alles erlaubt
 btst.b #2,gdp.w                * Ohne Sprung zu wait schneller
 beq.s putchar3
 bset.b #4, gdp+2*cpu.w         * 2. Zeichensatz setzen
 move.b d0,gdp.w                * Befehl ausgeben
putchar4:
 btst.b #2,gdp.w                * GDP fertig?
 beq.s putchar4                 * sonst Darstellungsfehler
 bclr.b #4, gdp+2*cpu.w         * wieder 1. Zeichensatz
 or.b #$80, d0                  * Bit 7 = 1
rts

putchar0:
 movem.l d1/a0-a1,-(a7)
 lea ztab0(pc),a1               * Zeichencode
 lea ztab2(pc),a0               * Bit-Tabelle
 moveq #anztab-1,d1
putcharlp:
 cmp.b (a1)+,d0                 * Vergleich, ob es dieses Zeichen ist
 beq.s putchar1                 * Ja, dann Ausgabe
 addq.l #5,a0                   * Sonst auch neue Einstellung der Bit-Tabelle
dbra d1,putcharlp
bra.s putchar2                  * Ende, da nicht gefunden
putchar1:
 bsr.s progzge                  * Ausgabe des Sonderzeichens
putchar2:
 movem.l (a7)+,d1/a0-a1
rts

getcode:                        * Bei deutschem Zeichensatz, Bit 7 setzen
 tst.b optflag(a5)              * Amerikanischer Zeichensatz an ?
 beq carset                     * Ja, dann keine Wandlung
getcodeo:
 movem.l d1/a0,-(a7)
 cmp.b #2, optflag(a5)          * User Zeichensatz?
 beq.s getcode2                 * Ja, dann Bit 7 setzen
 lea ztab1(pc),a0               * Tabelle der Zeichen
 moveq #anztab-1,d1             * Anzahl der Zeichen
getcode1:
 cmp.b (a0)+,d0                 * Vergleich
 beq.s getcode2                 * OK, Zeichen gefunden
dbra d1,getcode1
bra.s getcode3                  * Nein, kein deutsches Zeichen
getcode2:
 bset #7,d0                     * Bit 7 setzen, da deutsches Zeichen
getcode3:
 movem.l (a7)+,d1/a0
rts

anztab equ 9                    * Anzahl der Sonderzeichen

ztab0:                          * Sonderzeichen
 dc.b $db,$dc,$dd,$fb,$fc,$fd,$fe
 dc.b $81,$82
 ds 0
ztab1:                          * Sonderzeichen fr Umcodierung
 dc.b $5b,$5c,$5d,$7b,$7c,$7d,$7e
 dc.b 1,2

ztab2:                          * Bitcode Sonderzeichen
 dc.b $7d,$0a,$09,$0a,$7d       * 
 dc.b $3d,$42,$42,$42,$3d       * 
 dc.b $7d,$40,$40,$40,$7d       * 
 dc.b $71,$54,$54,$78,$41       * 
 dc.b $00,$39,$44,$44,$39       * 
 dc.b $3d,$40,$40,$7d,$40       * 
 dc.b $00,$7f,$01,$4d,$32       * 

 dc.b $00,$7f,$3e,$1c,$08
 dc.b $08,$1c,$3e,$7f,$00

progzge:                        * Programmierbarer Zeichengenerator
 movem.l d0-d7/a0/a1,-(a7)
 lea gdp.w,a1
 bsr getxy                      * Aktuelle Position holen
 move.b gdp+3*cpu.w,d4          * Schriftgre auch
 cmp.b #$11,d4                  * Bei Gre $11
 beq.s prog11zge                * schnelle Extraroutine
 move.b gdp+5*cpu.w,-(a7)       * GDP-Register merken, da zerstrt
 move.b d4,d3                   * Gre merken
 lsr #4,d3                      * SizeX
 and #$f,d3                     * Nur 4 Bit
 subq #1,d3                     * -1 wegen Linienlnge
 and #$f,d3                     * Wieder nur 4 Bit
 move.b d3,gdp+5*cpu.w          * Lnge der Linien in X-Richtung
 and #$f,d4                     * Das gleiche mit SizeY
 subq #1,d4
 and #$f,d4                     * Aber nur merken fr Dbra
 moveq #5-1,d6                  * Breite 5 Punkte, da letzte Spalte leer
progzlp0:
 move.b (a0)+,d0                * Zeichen holen
 beq.s progz3                   * Wenn Null, dann kein Punkt in dieser Reihe
 moveq #8-1,d5                  * Hhe 8 Punkte
progzlp1:
 move d4,-(a7)                  * d4 retten, da fr Schleife bentigt
progzlp2:
 btst.b d5,d0                   * Bit testen
 beq.s progz2                   * Null, dann nicht zeichnen
 movep.w 8*cpu(a1),d7           * ==> Nur fr 68000/68010
progz0:
 btst.b #2,(a1)                 * Warten bis GDP fertig
 beq.s progz0
 move.b #$10,(a1)               * Linie zeichnen
progz1:
 btst.b #2,(a1)                 * Warten bis GDP fertig
 beq.s progz1
 movep.w d7,8*cpu(a1)           * ==> Nur fr 68000/68010
progz2:
 movep.w $a*cpu(a1),d7          * ==> Nur fr 68000/68010
 addq #1,d7                     * Y-Position erhhen
 movep.w d7,$a*cpu(a1)          * ==> Nur fr 68000/68010
dbra d4,progzlp2
 move (a7)+,d4                  * d4 zurck
dbra d5,progzlp1                * Nchste Reihe
progz3:
 add d3,d1                      * Neue X-Position
 addq #1,d1
 bsr movetoo                    * Nchste Spalte / Kein Wait
dbra d6,progzlp0
 add d3,d1
 addq #1,d1                     * Am Ende noch eine Spalte fr Abstand zwischen
 bsr movetoo                    * den Buchstaben
 move.b (a7)+,gdp+5*cpu.w       * GDP-Register zurck
 movem.l (a7)+,d0-d7/a0/a1
rts

prog11zge:                      * Schnelle Routine fr Schriftgre $11
 moveq #2,d3                    * WAIT-Bit GDP
 moveq #$80,d4                  * Befehl Punkt setzen
 moveq #5-1,d6                  * Breite
pro1g1zg:
 move.b (a0)+,d0                * Eine Spalte holen
 beq.s pro1g4zg                 * Wenn Null, dann kein Punkt in dieser Spalte
 moveq #8-1,d5                  * 8 Punkte Hhe
pro1g2zg:
 btst.b d5,d0                   * Bit testen
 beq.s pro1g3zg                 * Wenn nicht gesetzt, dann nchstes Bit testen
 move.b d4,(a1)                 * Befehl Punkt setzen ausfhren
pro1w1:
 btst.b d3,(a1)                 * Warten bis GDP fertig
 beq.s pro1w1
pro1g3zg:
 movep.w $a*cpu(a1),d7          * ==> Nur fr 68000/68010
 addq #1,d7                     * Y-Position erhhen
 movep.w d7,$a*cpu(a1)          * ==> Nur fr 68000/68010
dbra d5,pro1g2zg
pro1g4zg:
 addq #1,d1                     * X-Position erhhen fr nchste Spalte
 bsr movetoo
dbra d6,pro1g1zg
 addq #1,d1
 bsr movetoo                    * Abstand zwischen den Buchstaben beachten
 movem.l (a7)+,d0-d7/a0/a1
rts

scroll:                         * Screen nach oben scrollen
 movem.l d0-d2/a0-a2,-(a7)
 bsr homepos                    * Obere Kante des Bildschirms
 tst.b cotempo(a5)              * Hardware-Scroll eingeschaltet ?
 beq sscroll                    * Nein, dann weiter
 add.b coscroll(a5),d2          * Scroll-Wert bedenken
 move.b curx(a5),-(a7)          * Retten
 move.b cury(a5),-(a7)
 clr.b cury(a5)                 * Auf Null setzen, da oberste Zeile angesprochen
 clr.b curx(a5)                 * werden soll
 bsr erapen                     * Auf Lschen
 moveq #%00010000,d0            * Schreibseite 0
 bsr setpage                    * Leseseite 1
 cmp #246,d2                    * berlappt Zeile den Bildschirm ?
 bmi.s hscroll3                 * Nein, dann normale Ausgabe
 movem.l d3/d4/a6,-(a7)
 move.b groesse(a5),d3          * Gre holen
 and #$f0,d3                    * Nur X-Vergrerung lassen, da Dy immer 1
 lsr #3,d3                      * /16*2
 move d3,d4
 add d3,d3
 add d4,d3                      * Dx*6
 moveq #0,d0
 bsr getline                    * Zeileninfo der zu lschenden Zeile
 clr d1
 move.b (a1),d1                 * Anzahl der Zeichen
 muls d1,d3                     * Zeilenlnge in Pixel berechnet
 cmp #512,d3
 bmi.s hscroll0                 * Sollte nicht ber rechten Rand gehen
 move #511,d3                   * Maximal bis 511
hscroll0:
 clr d1
 lea gdp.w,a6                   * Wird bei gr1xline verlangt
 moveq #8-1,d4                  * Zeichenhhe ist 8
hscroll1:
 bsr gr1xline                   * Zeile lschen
 addq.b #1,d2                   * Nchste Zeile
dbra d4,hscroll1
 sub.b #10,coscroll(a5)         * Scrollwert ndern
 moveq #%01000000,d0            * Andere Seite
 move.b coscroll(a5),page1.w    * Scroll einstellen
 bsr setpage                    * Seite umschalten
 moveq #8-1,d4                  * Auch dort 8 Zeilen lschen
hscroll2:
 subq.b #1,d2
 bsr gr1xline
dbra d4,hscroll2
 movem.l (a7)+,d3/d4/a6         * Register zurck
bra.s hscroll4                  * Jetzt normal weiter
hscroll3:
 bsr movetoo                    * Positionieren
 bsr prtline1                   * Oberste Zeile lschen mit Bildschirmrand
 sub.b #10,coscroll(a5)         * Scroll-Wert
 moveq #%01000000,d0
 move.b coscroll(a5),page1.w    * An GDP
 bsr setpage                    * Seite 1 als Schreibseite
 bsr movetoo                    * Neu Positionieren
 bsr prtline1                   * Andere Seite Zeile lschen
hscroll4:
 bsr setpen                     * Wieder auf Schreiben
 move.b (a7)+,cury(a5)          * Register zurck
 move.b (a7)+,curx(a5)
 moveq #5,d1                    * Maximal 4 Sync-Impulse
 sub.b cotempo(a5),d1           * cotempo ist nmlich maximal 5
bra.s hscroll6                  * Wegen Abfrage auf -1
hscroll5:
 bsr sync                       * Warten
 beq.s hscroll5                 * Tempobestimmung beim Scroll
hscroll6:
dbra d1,hscroll5
bra.s sscroll1                  * Bildschirmspeicher in Ordnung bringen
sscroll:
 moveq #%01000000,d0            * Seite einstellen
 bsr setpage
 bsr movetoo                    * Anfangsposition fr Ausgabe
 bsr.s scrolupr                 * Eine Seite scrollen
 bsr seite0                     * Andere Seite whlen
 bsr.s scrolupr                 * Auch scrollen
sscroll1:                       * Einsprung von hscroll
 moveq #0,d0                    * Zeile Null whlen
 bsr getline                    * Daten errechnen
 move.b (a1),d0                 * Anzahl der Zeichen holen
 beq.s sscroll2                 * Leerzeile, dann OK
 subq #1,d0                     * Sonst -1 fr dbra
 clr.b (a1)                     * Anzahl der Zeichen ist jetzt Null
sscrolp:
 move.b #' ',(a0)+              * Mit Leerzeichen fllen
dbra d0,sscrolp                 * bis alle Zeichen berschrieben sind
sscroll2:
 lea lineptr(a5),a0             * Pointer auf Zeile
 move.b (a0),d0                 * Erste Zeile merken
 moveq #23-1,d1                 * 23 mal schieben
sscroll3:
 move.b 1(a0),(a0)+             * Schieben
dbra d1,sscroll3
 move.b d0,(a0)                 * Ehemalige erste Zeile ist jetzt letzte Zeile
 movem.l (a7)+,d0-d2/a0-a2
rts

scrolupr:
 bsr erapen                     * Auf Lschen
 bsr prtall                     * Seite lschen
 bsr setpen                     * Auf Schreiben
 bsr movetoo                    * Neue Position
bra prttop                      * Von Zeile 1 bis 24 ausgeben

charhandler:                    * Buchstabenverwaltung
 bsr.s char1han                 * Buchstaben ausgeben
 addq.b #1,curx(a5)             * X-Position erhhen
 cmp.b #79,curx(a5)             * Wenn kleiner als Position 79, dann OK
 bls.s charhanfi
 clr.b curx(a5)                 * Sonst auf Anfang nchste Zeile
 addq.b #1,cury(a5)             * Und Y-Position erhhen
 cmp.b #23,cury(a5)             * Auf unterster Zeile ?
 bls.s charhanfi                * Nein, dann OK
 move.b #23,cury(a5)            * Sonst auf unterste Zeile setzen
bra scroll                      * und scrollen
charhanfi:
rts

charoscr:                       * Buchstaben ausgeben ohne Scroll
 bsr.s char1han                 * Ausgabe
 cmp.b #79,curx(a5)             * Am Ende der Zeile angelangt ?
 bpl   carset                   * Ja, dann Ende
 addq.b #1,curx(a5)             * Sonst neue X-Position
bra     carres

char1han:                       * Achtung Register werden zerstrt
 movem.l d1-d3,-(a7)
 move.b d0,d3                   * Zeichen merken
 clr.b wrtpage(a5)              * Schreibseite
 clr.b viewpage(a5)             * Und Leseseite auf Null
 bsr aktpage                    * einstellen
 bsr aktcur                     * Auf aktuelle Cursorposition
 bsr calccur                    * Zeileninfo holen
 move.b curx(a5),d0             * Cursorposition holen
 addq.b #1,d0                   * und erhhen
 cmp.b (a1),d0                  * Wenn hier noch kein Zeichen vorhanden war
 bcs.s char0
 move.b d0,(a1)                 * Dann Zeichenzhler erhhen
char0:
 cmp #511,d1                    * Wenn zu weit rechts, dann
 bhi.s charfi                   * keine Ausgabe
 tst.b cotempo(a5)              * Hard-Scroll an ?
 bne.s char1                    * Ja, dann Ausgabe
 cmp #11,d2                     * Zu tief ?
 bmi.s charfi                   * Ja, dann keine Ausgabe
char1:
 bsr.s char2                    * Ausgabe des Zeichens
 move.b #1,wrtpage(a5)          * Andere Seite
 bsr aktpage
 bsr movetoo                    * Positionieren
 bsr.s char2                    * Ausgabe
charfi:
 move.b d3,(a2)                 * Zeichen auch in den Bildschirmspeicher
 movem.l (a7)+,d1-d3
rts

char2:
 cmp.b #' ',(a2)                * Leerzeichen an aktueller Stelle ?
 beq.s char3                    * Ja, dann kein Vorlschen
 bsr erapen                     * Auf Lschen
 move.b #10,gdp.w               * Block ausgeben
 tst.b cotempo(a5)              * Hardscroll an ?
 beq.s char3                    * Nein, weiter
 cmp #249,d2                    * Ausgabe-Wert im Bildschirm-Bereich ?
 bmi.s char3                    * Ja, dann weiter
 sub #256,d2                    * Andere Hlfte des Buchstaben ausgeben
 bsr moveto                     * Positionieren
 move.b #10,gdp.w               * Wieder Lschen
 add #256,d2                    * Alte Position
char3:
 bsr moveto                     * Neu positionieren
 bsr setpen                     * Auf Schreiben
 move.b d3,d0                   * Zeichen ausgeben
 tst.b cotempo(a5)              * Hardscroll an ?
 beq cmdput                     * Nein, dann Ausgabe Zeichen
 bsr cmdput                     * Ausgabe mit Sonderzeichen
 cmp #249,d2                    * Y-Pos im Screen-Bereich ?
 bmi.s char4                    * Ja, dann Ende
 sub #256,d2                    * Andere Hlfte des Buchstaben ausgeben
 bsr moveto                     * Positionieren
 add #256,d2                    * Alte Position
bra cmdput                      * Ausgabe Zeichen
char4:
rts

seite0:
 clr.b wrtpage(a5)              * Seite Null als Schreibseite
 move.b #1,viewpage(a5)         * Und Seite 1 als Leseseite
 bsr aktpage                    * einstellen
bra movetoo                     * Und positionieren

seite1:
 clr.b viewpage(a5)             * Seite 1 als Leseseite
 move.b #1,wrtpage(a5)          * Seite 0 als Schreibseite
 bsr aktpage
 bsr erapen                     * Auf Lschen
bra aktcur                      * Cursorposition berechnen

eraeoln:                        * Ende der Zeile lschen
 movem.l d0-d2/a0-a2,-(a7)
 bsr.s seite1                   * Seite 1 whlen
 bsr prtlinehs                  * Ende der Zeile lschen
 bsr.s seite0                   * Seite 0
 bsr prtlinehs                  * Ende der Zeile lschen
 bsr.s eraln                    * Auch Speicher in Ordnung bringen
 movem.l (a7)+,d0-d2/a0-a2
rts

eraln:
 bsr calccur                    * Zeileninfo holen
 move.b curx(a5),(a1)           * Anzahl der Zeichen bis zur Cursorposition
 moveq #80-1,d0                 * Maximal 80 Zeichen (-1 wegen dbra)
 sub.b (a1),d0                  * Cursorposition abziehen
eral1:
 move.b #' ',(a2)+              * Im Speicher lschen
dbra d0,eral1
rts

eraeos:                         * Ende der Seite lschen
 movem.l d0-d2/a0-a2,-(a7)
 bsr.s seite1                   * Seite 1
 bsr prtrest                    * Lschen
 bsr.s seite0                   * Seite 0
 bsr prtrest                    * Lschen
 bsr.s eraln                    * Rest der Zeile im Speicher in Ordnung bringen
 move.b cury(a5),d1             * Y-Position holen
eraxlp:
 addq.b #1,d1                   * Um eins erhhen, da erste Zeile bereits OK ist
 cmp.b #24,d1                   * Wenn letzte Zeile erreicht war, dann Ende
 beq.s erafx1
 move.b d1,d0                   * Nummer der Zeile
 bsr getline                    * Zeileninfo holen
 move.b (a1),d0                 * Anzahl der vorherigen Zeichen holen
 beq.s eraxlp                   * Kein Zeichen, dann nchste Zeile
 clr.b (a1)                     * Anzahl der Zeichen ist jetzt Null
erax1lp:
 move.b #' ',(a0)+              * Zeichen im Speicher lschen
 subq.b #1,d0                   * Zeichenzhler erniedrigen
 bne.s erax1lp                  * Bis alle Zeichen gelscht
bra.s eraxlp                    * Nchste Zeile
erafx1:
 movem.l (a7)+,d0-d2/a0-a2
rts

inschar:                        * Ein Zeichen einfgen
 movem.l d0-d3/a0-a2,-(a7)
 bsr calccur                    * Zeileninfo holen
 tst.b (a1)                     * Anzahl der Zeichen testen
 beq.s insend                   * Null, dann kein Einfgen ntig
 move.b curx(a5),d0             * Wenn Cursorposition
 cmp.b (a1),d0                  * grer ist als
 bhi.s insend                   * Anzahl der Zeichen, dann auch Ende
 bsr seite1                     * Seite 1 anwhlen
 move d1,d3
 bsr.s ins1                     * Einfgen
 move d3,d1
 bsr seite0                     * Seite 0 anwhlen
 bsr erapen                     * Auf Lschen schalten
 bsr.s ins1                     * Einfgen
 bsr calccur                    * Zeileninfo holen
 cmp.b #80,(a1)                 * Mehr Zeichen als 80 sind
 bpl.s ins2                     * nicht mglich
 addq.b #1,(a1)                 * Sonst ein Zeichen mehr vorhanden
ins2:
 lea 79(a0),a0                  * Letztes Zeichen der Zeile
ins3:
 cmpa.l a2,a0                   * Wenn Cursorposition erreicht ist,
 beq.s ins4                     * ist alles verschoben
 move.b -(a0),1(a0)             * sonst weiter schieben
bra.s ins3
ins4:
 move.b #' ',(a0)               * Leerzeichen an aktueller Stelle
insend:
 movem.l (a7)+,d0-d3/a0-a2
rts

ins1:
 bsr prtlinehs                  * Zeile lschen
 move.b groesse(a5),d0
 lsr #3,d0
 and #$1e,d0
 add d0,d1
 add d0,d0
 add d0,d1
 bsr moveto                     * Neu positionieren
 bsr setpen                     * Auf Schreiben
 cmp.b #79,curx(a5)             * Cursor an letzter Position ?
 bmi prt79hs                    * Nein, dann Rest ausgeben
rts

delchar:                        * Ein Zeichen lschen
 movem.l d0-d2/a0-a2,-(a7)
 bsr calccur                    * Zeileninfo holen
 tst.b (a1)                     * Wenn Anzahl der Zeichen Null ist, ist kein
 beq.s delend                   * Lschen ntig
 move.b curx(a5),d0             * Wenn Cursor hinter letztem Zeichen steht
 cmp.b (a1),d0                  * auch nicht
 bpl.s delend
 bsr seite1                     * Seite 1
 bsr.s del1                     * Lschen
 bsr seite0                     * Seite Null
 bsr erapen                     * Auf Lschen
 bsr.s del1                     * Auch Lschen
 bsr calccur                    * Zeileninfo holen
 subq.b #1,(a1)                 * Anzahl der Zeichen ist eins weniger
 move.b curx(a5),d0             * Cursorposition holen
del2:
 cmp.b #79,d0                   * Wenn Ende der Zeile erreicht
 bpl.s del3                     * dann Ende
 move.b 1(a2),(a2)+             * Sonst schieben
 addq.b #1,d0                   * Cursorposition erhhen fr Test
bra.s del2                      * Schleife
del3:
 move.b #' ',(a2)               * Hinten Leerzeichen setzen
delend:
 movem.l (a7)+,d0-d2/a0-a2
rts

del1:
 bsr prtlinehs                  * Zeile vorlschen
 bsr setpen                     * Auf Schreiben
 cmp.b #79,curx(a5)             * Wenn Cursor am Ende der Zeile steht, ist keine
 bpl.s del10                    * Ausgabe mehr ntig
 bsr movetoo                    * Sonst neu positionieren
 addq.b #1,curx(a5)             * Ab nchstem Zeichen
 bsr prtlinehs                  * Ausgabe der Zeile (verschoben)
 subq.b #1,curx(a5)             * Cursorposition wieder herstellen
del10:
rts

insline:                        * Eine Zeile einfgen
 movem.l d0-d2/a0-a2,-(a7)
 clr.b curx(a5)                 * Cursor steht danach auf erstem Zeichen
 bsr seite1                     * Seite 1
 bsr prtrest                    * Rest des Bildschirms lschen
 cmp.b #23,cury(a5)             * Wenn Cursor auf letzter Zeile, dann weiter
 bpl.s insl1
 addq.b #1,cury(a5)             * Sonst eine Zeile runter und Position holen
 movem d1-d2,-(a7)              * Rev 6.0 mu gerettet werden, weil seit Rev 6.0
 bsr aktcur                     * d1/d2 in aktcur zerstrt werden
 movem (a7)+,d1-d2
 subq.b #1,cury(a5)             * Cursorposition wieder in Ordnung bringen
 bsr setpen                     * Auf Schreiben
 bsr prtr23                     * Rest ausgeben
insl1:
 bsr seite0                     * Das gleiche nochmal auf der anderen Seite
 bsr erapen
 bsr prtrest                    * Rest lschen
 bsr setpen
 cmp.b #23,cury(a5)
 bpl.s insl2
 addq.b #1,cury(a5)
 bsr aktcur
 subq.b #1,cury(a5)
 bsr prtr23                     * Ausgabe wenn ntig
insl2:
 lea lineptr(a5),a0             * Zeiger auf Zeile im Bildschirmbereich
 moveq #0,d0
 move.b cury(a5),d0
 adda.l d0,a0                   * Von Cursorposition an verschieben
 lea lineptr+23(a5),a1
 move.b (a1),d1                 * Letzte Zeile merken
insl3:
 cmpa.l a1,a0                   * Letzte Zeile ?
 beq.s insl4                    * Ja, Ende
 move.b -(a1),1(a1)             * Verschieben
bra.s insl3
insl4:
 move.b d1,(a1)                 * Letzte Zeile ist jetzt Zeile an Cursorposition
bra.s delline0                  * ( Im Speicher )

delline:                        * Eine Zeile lschen
 movem.l d0-d2/a0-a2,-(a7)
 clr.b curx(a5)                 * Cursor ist danach auf Zeilenanfang
 bsr seite1                     * Auf Seite 1
 bsr.s dell1                    * ausgeben
 bsr seite0                     * Dann auf Seite Null
 bsr erapen                     * Auf Lschen
 bsr.s dell1                    * Ausgabe
 lea lineptr(a5),a0             * Zeiger auf Zeile
 moveq #0,d0
 move.b cury(a5),d0
 adda.l d0,a0                   * Von Cursorposition an verschieben
 move.b (a0),d1                 * Merken
dell3:
 move.b 1(a0),(a0)+             * Verschieben
 addq.b #1,d0                   * Bis Ende der Seite
 cmp.b #24,d0                   * erreicht
 bne.s dell3
 move.b d1,-(a0)                * Zurck
 moveq #23,d0                   * Zeileninfo letzte Zeile
delline0:
 bsr getline                    * Zeileninfo holen
 move.b (a1),d0                 * Anzahl der Zeichen holen
 beq.s dell5                    * Null, dann kein Lschen
 clr.b (a1)                     * Anzahl, der Zeichen ist Null
dell4:
 move.b #' ',(a0)+              * Mit Leerzeichen fllen
 subq.b #1,d0                   * Bis alle gelscht
 bne.s dell4
dell5:
 movem.l (a7)+,d0-d2/a0-a2
rts

dell1:
 bsr prtrest                    * Rest der Seite lschen
 bsr setpen                     * Auf Schreiben
 cmp.b #23,cury(a5)             * Wenn letzte Zeile, dann kein Ausgeben mehr
 bpl.s dell2
 bsr movetoo                    * Sonst neu positionieren
 addq.b #1,cury(a5)             * Von nchster Zeile an
 bsr prtrest                    * Ausgabe
 subq.b #1,cury(a5)             * Y-Koordinate wieder auf alten Wert
dell2:
rts

eschandler:
 move.b #1,escmerker(a5)        * Escape anschalten
rts

esc1:
 cmp.b #2,escmerker(a5)         * Merker auf 2 ?
 bne.s esc2                     * Nein, dann weiter
 sub.b #32,d0                   * Sonst Befehl Y-Position einstellen
 and.l #$ff,d0                  * Fr Divs Langwort ntig
 divu #24,d0                    * Dividieren
 swap d0                        * Rest nehmen, damit nicht ber 24
 move.b d0,cury(a5)             * Cursor einstellen
 move.b #3,escmerker(a5)        * Flag, da dann X-Position folgt
rts

esc2:
 cmp.b #3,escmerker(a5)         * Jetzt X einstellen ?
 bne.s esc3                     * Nein, weiter
 clr.b escmerker(a5)            * Auf Null setzen, da Escape-Sequenz zu Ende
 sub.b #32,d0                   * Wandeln, da Eingabe als ASCII-Zeichen
 and.l #$ff,d0                  * Langwort ntig
 divu #80,d0                    * Auch hier Division
 swap d0                        * Und Rest nehmen
 move.b d0,curx(a5)             * Nach curx
 movem.l d1-d2,-(a7)
 bsr aktcur                     * Und Position einstellen
 movem.l (a7)+,d1-d2
rts

esc3:
 cmp.b #'=',d0                  * Befehl Cursor setzen
 bne.s esc4
 move.b #2,escmerker(a5)        * Flag dafr
rts

esc4:
 bsr.s esc5                     * Alles abfragen
 clr.b escmerker(a5)            * Danach Flag lschen, da ESC-Befehl zu Ende
rts

esc5:
 bsr wait                       * Warten, bis GDP fertig
 move.b groesse(a5),gdp+3*cpu.w * Gre einstellen zur Sicherheit
 cmp.b #'Q',d0
 beq inschar                    * Zeichen einfgen
 cmp.b #'W',d0
 beq delchar                    * Zeichen lschen
 cmp.b #'E',d0
 beq insline                    * Zeile einfgen
 cmp.b #'R',d0
 beq delline                    * Zeile lschen
 cmp.b #'T',d0
 beq eraeoln                    * Rest der Zeile lschen
 cmp.b #'Y',d0
 beq eraeos                     * Rest der Seite lschen
 cmp.b #'$',d0
 bne.s esc6
 move.b #1,optflag(a5)          * Zeichensatz auf deutsch umschalten
rts
esc6:
 cmp.b #'%',d0
 bne.s esc6a
 clr.b optflag(a5)              * Zeichensatz auf amerikanisch
rts
esc6a:
 btst.b #6, keydil(a5)          * GDP-FPGA da?
 beq.s esc7                     * nein, dann kein Umschalten
 cmp.b #'&',d0
 bne.s esc7
 move.b #2,optflag(a5)          * Zeichensatz auf User-Definiert
rts
esc7:
 cmp.b #'0',d0                  * Auf Software-Scroll umschalten
 bne.s esc8
 tst.b cotempo(a5)              * War schon, dann nichts machen
 beq carres
 movem.l d1-d2,-(a7)
 clr.b cotempo(a5)              * Auf Software-Scroll
 bsr homepos                    * Position links oben
 moveq #%01000000,d0
 bsr setpage                    * Seite 0
 bsr clrinvis                   * Seite lschen
 bsr moveto                     * Neue Position
 bsr prtall                     * Ausgabe
 clr.b page1.w                  * Scroll aus
 clr.b coscroll(a5)             * Auch Merker aus
 moveq #%00010000,d0            * Andere Seite
 bsr setpage
 bsr clrinvis                   * Lschen
 bsr moveto                     * Positionieren
 bsr prtall                     * Ausgabe neu
 bsr aktpage                    * Alte Seite
 movem.l (a7)+,d1-d2
rts
esc8:
 cmp.b #'1',d0                  * Hardware-Scroll verschiedene Geschwindigkeiten
 bmi.s esc10
 cmp.b #'5',d0
 bhi.s esc10
 btst.b #0,ioflag(a5)           * Neue GDP ?
 beq.s esc9                     * Nein, dann sind die Befehle verboten
 swap d0                        * d0 nicht zerstren
 move.b groesse(a5),d0          * Gre holen
 and.b #$f,d0                   * Nur Y-Vergrerung
 cmp.b #1,d0                    * Nicht 1 ?
 bne.s esc9                     * Ja, dann ist Hard-Scroll nicht erlaubt
 swap d0
 and #7,d0
 move.b d0,cotempo(a5)          * Merken der neuen Scroll-Art
esc9:
rts
esc10:
 cmp.b #'O',d0                  * Hardcopy-Funktionen
 bne.s esc11
esc10a:
 movem.l d6/d7/a3,-(a7)
 lea lo2(pc),a3                 * Ohne Zeichensatzumschaltung
 bsr.s esc12
 movem.l (a7)+,d6/d7/a3
rts
esc11:
 cmp.b #'P',d0
 bne.s esc13
esc11a:
 movem.l d6/d7/a3,-(a7)
 bsr initdr                     * Initialisierung
 lea lo(pc),a3                  * Mit Zeichensatzumschaltung
 bsr.s esc12
 bsr drmenq                     * Seitenvorschub
 movem.l (a7)+,d6/d7/a3
rts
esc12:
 moveq #24-1,d7                 * 24 Zeilen ausgeben
esc12a:
 moveq #23,d0
 sub d7,d0                      * Von 0 bis 23
 bsr getline                    * Zeileninfo holen
 move.b (a1),d6                 * Anzahl der Zeichen
 beq.s esc12c                   * Null, dann nur Zeilenvorschub
esc12b:
 move.b (a0)+,d0                * Zeichen holen
 jsr (a3)                       * Ausgabe ber Drucker
 subq.b #1,d6
 bne.s esc12b                   * Bis Zeile ausgegeben ist
esc12c:
 bsr locrlf                     * Zeilenvorschub
dbra d7,esc12a                  * Bis alle Zeilen ausgegeben sind
esc13:
rts

ctrlhandler:                    * Controlzeichen-Auswertung
 cmp.b #$8,d0                   * BS ?
 bne.s ctr1                     * Nein, weiter ?
 tst.b curx(a5)                 * Schon am Anfang der Zeile ?
 beq.s ctr01                    * Ja, dann weiter
 subq.b #1,curx(a5)             * Sonst X-Position erniedrigen
rts
ctr01:
 tst.b cury(a5)                 * Obere Zeile erreicht ?
 beq.s ctr02                    * Ja, dann OK
 move.b #79,curx(a5)            * Sonst ans Ende der
 subq.b #1,cury(a5)             * vorherigen Zeile
ctr02:
rts
ctr1:
 cmp.b #$1a,d0                  * Ctrl-Z
 beq clrscreen                  * Bildschirm lschen
ctr2:
 cmp.b #$1e,d0                  * Ctrl-^
 bne.s ctr3
ctr2a:
 clr.b curx(a5)                 * X-Position ist Null
 clr.b cury(a5)                 * Y-Position auch
rts

ctr3:
 cmp.b #$b,d0                   * Ctrl-K
 bne.s ctr4
 tst.b cury(a5)                 * Oberste Zeile erreicht ?
 beq.s ctr31                    * Ja, dann nichts ndern
 subq.b #1,cury(a5)             * Sonst Cursor eine Zeile hoch
ctr31:
rts
ctr4:
 cmp.b #$a,d0                   * Ctrl-J
 bne.s ctr5
 cmp.b #23,cury(a5)             * Unterste Zeile erreicht ?
 bpl scroll                     * Ja, dann scrollen
 addq.b #1,cury(a5)             * Sonst Cursor eine Zeile runter
rts
ctr5:
 cmp.b #$16,d0                  * Ctrl-V
 bne.s ctr6
 cmp.b #23,cury(a5)             * Wie Ctrl-J aber ohne Scroll
 bpl.s ctr51
 addq.b #1,cury(a5)
ctr51:
rts
ctr6:
 cmp.b #$c,d0                   * Ctrl-L
 beq.s ctr61
 cmp.b #$9,d0                   * Und Ctrl-I
 bne.s ctr7
ctr61:
 cmp.b #79,curx(a5)             * Letztes  Zeichen in einer Reihe erreicht ?
 bne.s ctr62                    * Nein, dann weiter
 clr.b curx(a5)                 * An Anfang der Zeile
 cmp.b #23,cury(a5)             * Letzte Zeile erreicht ?
 bpl scroll                     * Ja, dann Scroll
 addq.b #1,cury(a5)             * Sonst nur erhhen
rts
ctr62:
 addq.b #1,curx(a5)             * Cursor nach rechts
rts
ctr7:
 cmp.b #$d,d0                   * Ctrl-M
 bne.s ctr8
 clr.b curx(a5)                 * An Anfang der Zeile
ctr8:
rts

prtco:                          * Text von a0 an ber co ausgeben
 move.b (a0)+,d0                * Zeichen holen
 beq.s prt1co                   * Null ist Ende
 move.l a0,-(a7)                * a0 retten, da zerstrt
 bsr.s co                       * Ausgabe Zeichen
 movea.l (a7)+,a0               * a0 zurck
bra.s prtco                     * Schleife
prt1co:
rts

co:                             * Bildschirmverwaltungsroutine ohne Umlenkung
 tst.b escmerker(a5)            * Wurde ESC eingschaltet
 bne esc1                       * Ja, dann aufrufen
 cmp.b #$1b,d0                  * ESCAPE ?
 beq eschandler                 * Ja, dann Auswertung
 bsr wait                       * Warten, bis GDP fertig
 move.b groesse(a5),gdp+3*cpu.w * Gre einstellen zur Sicherheit
 cmp.b #' ',d0                  * Kleiner als ' ', dann
 bcs ctrlhandler                * CTRL-Zeichen
bra charhandler                 * Sonst normales ASCII-Zeichen


                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 90 Grad
gr1u3a:
 move -(a3),d1                  * Sinus
 muls d3,d1                     * Mal X-Radius
 asr.l #8,d1                    * Durch 256
 add d5,d1                      * X-Koordinate berechnet
 move (a2)+,d2                  * Cosinus
 muls d4,d2                     * Mal Y-Radius
 asr.l #8,d2                    * Durch 256
 asr.l #1,d2                    * Bildschirmformat
 add d6,d2                      * Y-Koordinate berechnet
 movem d1/d2,(a1)               * X,Y merken
g